import { Component, OnInit } from '@angular/core';
import { FormControl } from '@angular/forms';
import { Observable } from 'rxjs';
import { map, startWith } from 'rxjs/operators';
import { SearchService } from '../services/search.service';

@Component({
  selector: 'app-zone',
  templateUrl: './zone.component.html',
  styleUrls: ['./zone.component.scss'],
})
export class ZoneComponent implements OnInit {
  zones: string[] = ['Zone 1', 'Zone 2', 'Zone 3']; // Example data
  searchControl = new FormControl('');
  selectedZone: string = '';
  filteredZones: Observable<string[]> | undefined;

  constructor(private sharedService: SearchService) {}

  ngOnInit() {
    this.filteredZones = this.searchControl.valueChanges.pipe(
      startWith(''),
      map((value) => this._filterZones(value || ''))
    );
  }

  private _filterZones(value: string): string[] {
    const filterValue = value.toLowerCase();
    return this.zones.filter((zone) =>
      zone.toLowerCase().includes(filterValue)
    );
  }

  onSelectionChange() {
    this.sharedService.selectedZone = this.selectedZone;
    this.searchControl.setValue(''); // Clear search input
  }
}
