import { Component, OnInit } from '@angular/core';

import { FormControl } from '@angular/forms';
import { Observable } from 'rxjs';
import { map, startWith } from 'rxjs/operators';
import { SearchService } from '../services/search.service';

@Component({
  selector: 'app-survey',
  templateUrl: './survey.component.html',
  styleUrl: './survey.component.scss',
})
export class SurveyComponent implements OnInit {
  zones: string[] = ['Survey 1', 'Survey 2', 'Survey 3']; // Example data
  searchControl = new FormControl('');
  selectedSurvey: string = '';
  filteredZones: Observable<string[]> | undefined;

  constructor(private sharedService: SearchService) {}

  ngOnInit() {
    this.filteredZones = this.searchControl.valueChanges.pipe(
      startWith(''),
      map((value) => this._filterZones(value || ''))
    );
  }

  private _filterZones(value: string): string[] {
    const filterValue = value.toLowerCase();
    return this.zones.filter((zone) =>
      zone.toLowerCase().includes(filterValue)
    );
  }

  onSelectionChange() {
    this.sharedService.selectedSurvey = this.selectedSurvey;
    this.searchControl.setValue(''); // Clear search input
  }
}
