import { NgModule } from '@angular/core';
import {
  BrowserModule,
  provideClientHydration,
} from '@angular/platform-browser';
import { BrowserAnimationsModule } from '@angular/platform-browser/animations';
import { FormsModule, ReactiveFormsModule } from '@angular/forms';
import { MatSelectModule } from '@angular/material/select';
import { MatInputModule } from '@angular/material/input';
import { MatFormFieldModule } from '@angular/material/form-field';
import { MatButtonModule } from '@angular/material/button';
import { MatToolbarModule } from '@angular/material/toolbar';

import { AppRoutingModule } from './app-routing.module';
import { AppComponent } from './app.component';
import { provideAnimationsAsync } from '@angular/platform-browser/animations/async';
import { AdminComponent } from './admin/admin.component';
import { SurveyComponent } from './survey/survey.component';
import { ChainageComponent } from './chainage/chainage.component';
import { ZoneComponent } from './zone/zone.component';
import { CircleComponent } from './circle/circle.component';
import { DivisionComponent } from './division/division.component';
import { SubdivisionComponent } from './subdivision/subdivision.component';
import { RoadComponent } from './road/road.component';
import { LinkComponent } from './link/link.component';
import { SurveyYearComponent } from './survey-year/survey-year.component';

@NgModule({
  declarations: [
    AppComponent,
    AdminComponent,
    SurveyComponent,
    ChainageComponent,
    ZoneComponent,
    CircleComponent,
    DivisionComponent,
    SubdivisionComponent,
    RoadComponent,
    LinkComponent,
    SurveyYearComponent,
  ],
  imports: [
    BrowserModule,
    AppRoutingModule,
    MatButtonModule,
    BrowserAnimationsModule,
    FormsModule,
    ReactiveFormsModule,
    MatSelectModule,
    MatInputModule,
    MatFormFieldModule,
    MatToolbarModule,
  ],
  providers: [provideClientHydration(), provideAnimationsAsync()],
  bootstrap: [AppComponent],
})
export class AppModule {}
